/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.class_loading.Boot;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogComparator;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class LogsList {
    private static final Set<Log> logs = Collections.synchronizedSet(new TreeSet<Log>(new LogComparator()));

    public static Set<Log> getLogs() {
        return logs;
    }

    public static boolean isLauncherLogExist() {
        return logs.stream().anyMatch(log -> log.getType() == LogType.LAUNCHER_LOG);
    }

    public static void addIfExistsAndModified(Log log) {
        LogsList.addIfExistsAndModified(log, true, true);
    }

    public static void addIfExistsAndModified(Log log, boolean checkModified, boolean checkSize) {
        if (Files.exists(log.getPath(), new LinkOption[0]) && Files.isRegularFile(log.getPath(), new LinkOption[0])) {
            if (CrashAssistantConfig.getBlacklistedLogs().stream().anyMatch(bl_log -> log.getFileName().startsWith((String)bl_log))) {
                return;
            }
            if (checkModified && log.getPath().toFile().lastModified() <= Boot.parentStarted) {
                return;
            }
            try {
                if (checkSize && Files.size(log.getPath()) == 0L) {
                    CrashAssistantApp.LOGGER.warn("File \"" + String.valueOf(log.getPath()) + "\" is empty.");
                    return;
                }
            }
            catch (IOException e) {
                CrashAssistantApp.LOGGER.error("Error while checking file size \"" + String.valueOf(log.getPath()) + "\": ", (Throwable)e);
            }
            Path newPath = log.getPath().toAbsolutePath().normalize();
            for (Log existingLog : logs) {
                if (!existingLog.getPath().toAbsolutePath().normalize().equals(newPath)) continue;
                CrashAssistantApp.LOGGER.info("Skipping duplicate log as it's already added to the list: " + String.valueOf(log.getPath()));
                return;
            }
            CrashAssistantApp.LOGGER.info("Adding {} from {}", (Object)log.getName(), (Object)log.getPath().toAbsolutePath().toString());
            logs.add(log);
        }
    }
}

